<?php
#
# Read SOAP message example for devices with CO2 measurement
#
# Requirements: Tx5xx device with CO2 measurement and firmware version 1-5-7-4 or higher
#               Apache server (tested with version 2.4.23)
#               PHP (tested with version 5.6.25)
#               Enabled SOAP extension for PHP
#               Uncommented line always_populate_raw_post_data = -1 in php.ini file
#
#  Purpose of this example is demonstration of communication with Tx5xx/Tx6xx device.
#  It is not intended to be used in production environment without further changes.
#

function InsertTx5xxCO2Sample($passKey,$device,
                              $temp,$relHum,$compQuant,$co2,
                              $alarms,
                              $level1, $level2, $level3,
                              $compType,$tempU, $timer) {

  $txt = "Time: ".StrFTime("%y-%m-%d %H:%M:%S", Time()).", Temp: ".$temp.", RH: ".$relHum.", CQ: ".$compQuant.", CO2: ".$co2."\r\n";

  $myfile = fopen("logs.txt", "a");
  fwrite($myfile, $txt);
  fclose($myfile);
}

$server = new SoapServer(null, array('uri' => "http://test-uri/"));
$server->addFunction('InsertTx5xxCO2Sample');
$server->handle();
?>
