#
# Simple HTTP server to reading SOAP messages from Tx5xx/Tx6xx devices
#
# Requirements: Python 3.6.1 ( www.python.org )
#               Tx5xx/Tx6xx device with firmware version 1-5-7-4 or higher
#               Allowed port in firewall
#
#  Purpose of this example is demonstration of communication with Tx5xx/Tx6xx device.
#  It is not intended to be used in production environment without further changes.
#

# TCP port for http server
PORT = 8080
# tags from SOAP XML file
seq = ['temp', 'relHum', 'compQuant', 'pressure']

from http.server import BaseHTTPRequestHandler, HTTPServer
import xml.etree.ElementTree as ET

class HTTPServer_RequestHandler(BaseHTTPRequestHandler):

    # POST request handler
    def do_POST(self):
        # read POST data
        length = int(self.headers['Content-Length'])
        data = self.rfile.read(length).decode()
        print('POST-path:', self.path, ', POST-data-len:', length)
        #print(data)

        # parse XML in POST data
        xmldoc = ET.fromstring(data)[0][0]
        for child in xmldoc:
          for tagname in seq:
              if child.tag.endswith(tagname) > 0:
                   print(tagname, child.text)

        # send back response do device (HTTP/1.1 is mandatory)
        self.protocol_version = 'HTTP/1.1'
        self.send_response(200)
        self.end_headers()
        return

    # disable server log messages
    def log_message(self, format, *args):
        return

# run HTTP server
def run():
    print('Starting HTTP server...')
    httpd = HTTPServer(("", PORT), HTTPServer_RequestHandler)
    httpd.serve_forever()

run()
